#include <bits/stdc++.h>

using namespace std;

typedef long long ll;
typedef string ss;

#define pb push_back
#define speed ios_base::sync_with_stdio(0), cin.tie(0), cout.tie(0)
#define pii pair < int, int >
#define pll pair < ll, ll >
#define all(a) a.begin(), a.end()

const int N = 4e3 + 5, INF = int(1e9), mod = 998244353, base = 10, block = 300;

const double eps = 1e-9;

const ll BIG = ll(1e18);

int _ = 1, n, p[N], sz[N], cnt[N];

int get(int v){
    if(v == p[v])
        return v;
    return p[v] = get(p[v]);
}

void unite(int v, int u){
    v = get(v);
    u = get(u);
    if(sz[v] < sz[u])
        swap(u, v);
    sz[v] += sz[u];
    p[u] = p[v];
}

struct point{
    ll x, y;
};

point a[N], b[N];

int dir(point a, point b, point c){
    ll val = (b.y - a.y) * (c.x - b.x) - (b.x - a.x) * (c.y - b.y);
    if(!val)
        return 0;
    return (val > 0) ? 1 : -1;
}

bool check(point a, point c, point b){
    return (c.x <= max(a.x, b.x) and c.x >= min(a.x, b.x)) and (c.y <= max(a.y, b.y) and c.y >= min(a.y, b.y));
}


bool intersection(point a, point b, point c, point d){
    int o1 = dir(a, b, c);
    int o2 = dir(a, b, d);
    int o3 = dir(c, d, a);
    int o4 = dir(c, d, b);
    if(o1 != o2 and o3 != o4)
        return 1;
    if(!o1 and check(a, c, b))
        return 1;
    if(!o2 and check(a, d, b))
        return 1;
    if(!o3 and check(c, a, d))
        return 1;
    if(!o4 and check(c, b, d))
        return 1;
    return 0;
}

void clear(){
}

void solve(){
    cin >> n;
    for(int i = 1; i <= n; i++){
        p[i] = i;
        sz[i] = 1;
    }
    for(int i = 1; i <= n; i++){
        cin >> a[i].x >> a[i].y;
        cin >> b[i].x >> b[i].y;
    }
    int ans = 0;
    for(int i = 1; i <= n; i++){
        for(int j = 1; j <= n; j++){
            cnt[j] = 0;
        }
        for(int j = 1; j < i; j++){
            if(intersection(a[i], b[i], a[j], b[j])){
                cnt[get(j)]++;
            }
        }
        for(int j = 1; j <= n; j++){
            ans += max(0, cnt[j] - 1);
        }
        for(int j = 1; j <= n; j++){
            if(cnt[j]){
                unite(i, j);
            }
        }
    }
    cout << ans + 1 << endl;
}

int main(){
    speed;
    cin >> _;
    while(_--){
        solve();
        clear();
    }
}
